#include <Arduino.h>

#define LEDPIN 2

// Eine Funktion ohne Rückgabewert, darum vom Typ void
// 3 Argument vom Typ int, also eine ganze Zahl (-2^31 bis 2^31-1)
void wiederhole(int mal, int msOn, int msOff) {
  for (int i=0; i<mal; i++) { // Wiederholen
    digitalWrite(LEDPIN, HIGH);   // 3.3V auf LEDPIN
    delay(msOn);                  // So viele Millisekunden warten
    digitalWrite(LEDPIN, LOW);    // 0V auf LEDPIN
    delay(msOff);                  
  }
}

// Wird einmal ausgeführt, wenn der Mikrocontroller neu startet
void setup() {
  pinMode(LEDPIN, OUTPUT);  
}

// Wir nach dem setup immer wieder ausgeführt
void loop() {
  wiederhole(3, 100, 400);
  delay(700);

  wiederhole(3, 400, 100);
  delay(700);

  wiederhole(3, 100, 400);
  delay(1400);
}